/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.toolkit.dialog;

import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class VWTaskModalDialog
extends VWModalDialog
implements ActionListener {
    public static final int DEFAULT_OPTION = 16;
    public static final int YES_OPTION = 1;
    public static final int NO_OPTION = 2;
    public static final int CANCEL_OPTION = 4;
    public static final int OK_OPTION = 8;
    public static final int CLOSE_OPTION = 16;
    public static final int HELP_OPTION = 32;
    public static final int CONTINUE_OPTION = 64;
    private JButton m_yesButton = null;
    private JButton m_noButton = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private JButton m_continueButton = null;
    private int m_optType = 16;
    private int m_buttonSelected = 16;
    private String m_helpURL = null;

    public VWTaskModalDialog(Frame parent, JPanel panel, String title, int optionType, String helpURL, Dimension size) {
        super(parent);
        this.init(parent, panel, title, optionType, helpURL, size);
    }

    public static int showDialog(Frame parent, JPanel panel, String title, int optionType, String helpURL, Dimension size) {
        VWTaskModalDialog dlg = new VWTaskModalDialog(parent, panel, title, optionType, helpURL, size);
        dlg.setVisible(true);
        dlg.dispose();
        return dlg.buttonSelected();
    }

    protected void performValidation() throws Exception {
    }

    protected void processButtonEvent(int button) throws Exception {
    }

    public void actionPerformed(ActionEvent event) {
        try {
            int buttonOption = this.getButtonOption((JButton)event.getSource());
            if (buttonOption == 32 && this.m_helpURL != null) {
                VWHelp.displayPage(this.m_helpURL);
                return;
            }
            if (buttonOption == 8 || buttonOption == 1 || buttonOption == 64) {
                this.performValidation();
            }
            this.m_buttonSelected = buttonOption;
            this.processButtonEvent(buttonOption);
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWTaskCore.getInstance().displayError((Throwable)ex, false);
        }
    }

    private int getButtonOption(JButton button) {
        if (button == this.m_yesButton) {
            return 1;
        }
        if (button == this.m_noButton) {
            return 2;
        }
        if (button == this.m_okButton) {
            return 8;
        }
        if (button == this.m_cancelButton) {
            return 4;
        }
        if (button == this.m_closeButton) {
            return 16;
        }
        if (button == this.m_continueButton) {
            return 64;
        }
        if (button == this.m_helpButton) {
            return 32;
        }
        return -1;
    }

    private void init(Window parent, JPanel panel, String title, int optionType, String helpURL, Dimension size) {
        try {
            this.m_optType = optionType;
            if (title != null) {
                this.setTitle(title);
            }
            if (helpURL != null) {
                this.setHelpURL(helpURL);
            }
            if (size == null) {
                this.setSize(new Dimension(400, 120));
            } else {
                this.setSize(size);
            }
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createButtonPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new FlowLayout());
            if ((this.m_optType & 1) == 1) {
                this.m_yesButton = new JButton(VWResource.s_yes);
                this.m_yesButton.addActionListener(this);
                this.getRootPane().setDefaultButton(this.m_yesButton);
                mainPanel.add(this.m_yesButton);
            }
            if ((this.m_optType & 2) == 2) {
                this.m_noButton = new JButton(VWResource.s_no);
                this.m_noButton.addActionListener(this);
                mainPanel.add(this.m_noButton);
            }
            if ((this.m_optType & 8) == 8) {
                this.m_okButton = new JButton(VWResource.s_ok);
                this.m_okButton.addActionListener(this);
                this.getRootPane().setDefaultButton(this.m_okButton);
                mainPanel.add(this.m_okButton);
            }
            if ((this.m_optType & 0x40) == 64) {
                this.m_continueButton = new JButton(VWResource.s_continue);
                this.m_continueButton.addActionListener(this);
                this.getRootPane().setDefaultButton(this.m_continueButton);
                mainPanel.add(this.m_continueButton);
            }
            if ((this.m_optType & 4) == 4) {
                this.m_cancelButton = new JButton(VWResource.s_cancel);
                this.m_cancelButton.addActionListener(this);
                mainPanel.add(this.m_cancelButton);
            }
            if ((this.m_optType & 0x10) == 16) {
                this.m_closeButton = new JButton(VWResource.s_close);
                this.m_closeButton.addActionListener(this);
                mainPanel.add(this.m_closeButton);
            }
            if ((this.m_optType & 0x20) == 32) {
                this.m_helpButton = new JButton(VWResource.s_help);
                this.m_helpButton.addActionListener(this);
                mainPanel.add(this.m_helpButton);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public int buttonSelected() {
        return this.m_buttonSelected;
    }

    private void setHelpURL(String helpURL) {
        this.m_helpURL = helpURL;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:40:32  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }
}

